/**
 * PayHive Checkout Script
 * 
 * Handles interactive provider selection on WooCommerce checkout
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Update selected class when radio buttons change
        function updateSelectedState() {
            $('.payhive-provider-radio').each(function() {
                var $radio = $(this);
                var $option = $radio.closest('.payhive-provider-option');
                
                if ($radio.is(':checked')) {
                    $option.addClass('selected');
                } else {
                    $option.removeClass('selected');
                }
            });
        }

        // Handle radio button changes
        $(document).on('change', '.payhive-provider-radio', function() {
            updateSelectedState();
        });

        // Handle clicks on provider cards (for better UX)
        $(document).on('click', '.payhive-provider-card', function(e) {
            e.preventDefault();
            var $option = $(this).closest('.payhive-provider-option');
            var $radio = $option.find('.payhive-provider-radio');
            
            if ($radio.length) {
                $radio.prop('checked', true).trigger('change');
            }
        });

        // Initialize selected state on page load
        updateSelectedState();

        // Update when payment method changes (WooCommerce checkout)
        $(document.body).on('updated_checkout', function() {
            updateSelectedState();
        });
    });

})(jQuery);




