/**
 * PayHive Payments - Frontend JavaScript
 */

(function ($) {
    'use strict';

    $(document).ready(function () {
        // Handle payment form submission
        $('.payhive-payment-form').on('submit', function (e) {
            e.preventDefault();

            const form = $(this);
            const wrapper = form.closest('.payhive-payment-wrapper');
            const submitBtn = form.find('.payhive-submit-btn');
            const messageBox = form.find('.payhive-message');
            const loader = form.find('.payhive-loader');
            const resultBox = wrapper.find('.payhive-result');

            // Clear previous messages
            messageBox.hide().removeClass('success error').text('');
            resultBox.hide();

            // Validate form
            const name = form.find('input[name="customer_name"]').val().trim();
            const email = form.find('input[name="customer_email"]').val().trim();
            const phone = form.find('input[name="customer_phone"]').val().trim();

            if (name === '' || email === '' || phone === '') {
                showMessage(messageBox, 'Please fill in all required fields.', 'error');
                return;
            }

            // Validate email
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                showMessage(messageBox, 'Please enter a valid email address.', 'error');
                return;
            }

            // Disable submit button and show loader
            submitBtn.prop('disabled', true);
            loader.show();

            // Prepare form data
            const formData = {
                action: 'payhive_create_payment',
                nonce: payhiveAjax.nonce,
                amount: form.find('input[name="amount"]').val(),
                description: form.find('input[name="description"]').val(),
                currency: form.find('input[name="currency"]').val(),
                customer_name: name,
                customer_email: email,
                customer_phone: phone
            };

            // Make AJAX request
            $.ajax({
                url: payhiveAjax.ajax_url,
                type: 'POST',
                data: formData,
                success: function (response) {
                    loader.hide();
                    submitBtn.prop('disabled', false);

                    if (response.success) {
                        // Hide form and show result
                        form.hide();

                        let resultHtml = '<h3>Payment Link Created!</h3>';
                        resultHtml += '<p>Your payment link has been generated successfully.</p>';

                        if (response.data.payment_link) {
                            resultHtml += '<a href="' + response.data.payment_link + '" class="payment-link" target="_blank">Click here to complete payment</a>';
                        }

                        if (response.data.payment_id) {
                            resultHtml += '<p style="margin-top:20px; font-size:12px; color:#666;">Payment ID: ' + response.data.payment_id + '</p>';
                        }

                        resultBox.html(resultHtml).show();
                    } else {
                        showMessage(messageBox, response.data.message || 'An error occurred.', 'error');
                    }
                },
                error: function (xhr, status, error) {
                    loader.hide();
                    submitBtn.prop('disabled', false);
                    showMessage(messageBox, 'Network error. Please try again.', 'error');
                    console.error('PayHive AJAX Error:', error);
                }
            });
        });

        // Helper function to show messages
        function showMessage(element, message, type) {
            element
                .text(message)
                .addClass(type)
                .show();

            // Scroll to message
            $('html, body').animate({
                scrollTop: element.offset().top - 100
            }, 500);
        }
    });

})(jQuery);
